/*************************************************************************************/
/* Pprava situace																	 */
/*************************************************************************************/
DROP DATABASE AtomicitaTransakci
CREATE DATABASE AtomicitaTransakci
USE AtomicitaTransakci
GO

-- Primitivn tabulka la bankovn et
CREATE TABLE Ucet
(
	UcetID int IDENTITY(1,1) NOT NULL,
	VlastnikID int NOT NULL,
	Zustatek money NOT NULL CONSTRAINT DF_Ucet_Zustatek  DEFAULT (0),
	CONSTRAINT PK_Ucet PRIMARY KEY CLUSTERED (UcetID ASC) 
) ON [PRIMARY]
GO





/*************************************************************************************/
/* Nechrnn operace																 */
/*************************************************************************************/

-- Zaloen dvou ukzkovch t s nulovm zstatkem (default)
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Operace mezi ty nechrnn transakc
UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1
UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO






/*************************************************************************************/
/* Transakce																		 */
/*************************************************************************************/

-- Pprava - smau a zalom ty znovu
DELETE FROM Ucet
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Transakce
BEGIN TRANSACTION
	UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1
	UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2
COMMIT TRANSACTION
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO






/************************************************************************************/
/* Transakce - Test pomoc problmov situace										*/
/************************************************************************************/

-- Vrtme ty na nulov zstatek
DELETE FROM Ucet
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Pidme constraint - Zporn zstatek nepipoutme
ALTER TABLE Ucet WITH CHECK ADD CONSTRAINT CK_Ucet_NezapornyZustatek CHECK (Zustatek >=0)
GO

-- Transakce
BEGIN TRANSACTION
	-- Zporn zstatek na tu nepipoutme, prvn UPDATE failuje
	UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1
	UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2
COMMIT TRANSACTION
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO













/*************************************************************************************/
/* Transakce - korekce se SET XACT_ABORT											 */
/*************************************************************************************/

/*
When SET XACT_ABORT is ON, if a Transact-SQL statement raises a run-time error,
the entire transaction is terminated and rolled back. 

Compile errors, such as syntax errors, are not affected by SET XACT_ABORT.
*/

-- Pprava situace
DELETE FROM Ucet
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Zapneme XACT_ABORT
SET XACT_ABORT ON
GO

-- Pevod 500 K z tu na et
BEGIN TRANSACTION
	
	-- Pkaz failuje, zstatek nesm bt zporn
	UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1

	UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2

COMMIT TRANSACTION
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO




	






/*************************************************************************************/
/* Transakce - korekce s kontrolou @@ERROR											 */
/*************************************************************************************/

-- Nyn XACT_ABORT nechceme
SET XACT_ABORT OFF

-- Pprava situace
DELETE FROM Ucet
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Pevod 500 K z tu na et
BEGIN TRANSACTION
	
	-- Pkaz failuje, zstatek nesm bt zporn
	UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1
	IF (@@ERROR <> 0)
	BEGIN
		ROLLBACK TRANSACTION -- Odvolme transakci
		RETURN -- Rollback nesta, musme opustit batch a zabrnit voln dalch pkaz!
	END

	UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2
	IF (@@ERROR <> 0)
	BEGIN
		ROLLBACK TRANSACTION -- Odvolme transakci
		RETURN -- Rollback nesta, musme opustit batch a zabrnit voln dalch pkaz!
	END

COMMIT TRANSACTION
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO









/*************************************************************************************/
/* Transakce - TRY-CATCH na SQL 2005+												 */
/*************************************************************************************/

-- Pprava situace
DELETE FROM Ucet
INSERT INTO Ucet(VlastnikID) VALUES(1)
INSERT INTO Ucet(VlastnikID) VALUES(2)
GO

-- Pevod 500 K z tu na et
BEGIN TRANSACTION

	BEGIN TRY	
		-- Pkaz failuje, zstatek nesm bt zporn
		UPDATE Ucet SET Zustatek = Zustatek - 500 WHERE VlastnikID = 1

		UPDATE Ucet SET Zustatek = Zustatek + 500 WHERE VlastnikID = 2
	END TRY
	BEGIN CATCH
		-- Podrobnosti o chyb
	   SELECT 
		  ERROR_NUMBER() AS ErrorNumber,
		  ERROR_SEVERITY() AS ErrorSeverity,
		  ERROR_STATE() as ErrorState,
		  ERROR_PROCEDURE() as ErrorProcedure,
		  ERROR_LINE() as ErrorLine,
		  ERROR_MESSAGE() as ErrorMessage;

		ROLLBACK TRANSACTION
		RETURN
	END CATCH

	IF (@@TRANCOUNT > 0) -- Dky RETURN ve nen ani poteba
		COMMIT TRANSACTION
GO

-- Co bude na tech?
SELECT * FROM Ucet
GO
